
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1102.C - Message 1102 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1102 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1102.C_v  $
//   
//      Rev 2.0   08 Dec 1999 16:18:14   phungh
//   Provide switching mechanism between
//   message 1102 and 1191( magna on)
//   
//      Rev 1.9   Jul 06 1998 09:09:40   BANHND
//   added more DR features
//   
//      Rev 1.6   Jul 09 1997 09:56:22   COLEJ
//   Multiple Changes...
//   
//      Rev 1.5   Feb 12 1997 16:05:22   COLEJ
//    
//   
//      Rev 1.4   Nov 14 1996 11:22:28   COLEJ
//   Corrected GPS Measurment Time calculation
//   
//      Rev 1.3   Oct 31 1996 11:28:56   COLEJ
//    
//   
//      Rev 1.2   Aug 19 1996 17:12:16   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 10:01:02   COLEJ
//   Added SV data extraction calls.
//   Turn off RNG during FXTRACT.
//   Repositioned sequence number.
//   
//      Rev 1.0   13 May 1996 14:52:52   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <graph.h>
#include <string.h>
#include <math.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h" 
#include "monshow.h"

#define CDX50TWOP45
#define CDTWOP45
#define MAGNA_ON 	0x0800  // bit 11 set

extern void XSVD(tMSG1102 *);
void ShowRNG(tMSG1102 *);

tDOUBLE utrip2dbl (tUTRIPLE *x);    

extern short  xtract;
extern short  fxtract;  
extern char   xtractid[4];
extern short  xtractchannel; 

extern short         MainTextColor;  
extern short         MainDataColor;  

// data from 1110 for temp calc
extern tFLOAT  TRef;
extern tDOUBLE S0;
extern tUSHORT T0;
extern tUSHORT MSG1110; // message on flag 

extern tBOOL   Flag1102;    

////////////////////////////////////////////////////////////////////////////////
//   
//   Show a Zodiac 1102 message
//      
void Show1102(tMSG1102 *Msg)
{  
   char      Buf[80] = ""; 
   double    GpsTimePhase;          // CB
   double    GpsTimeVelocity;       // CD
   double    TempMeasurement;       // Counts (0..65535)  made global to use in msg1110
   unsigned short   Counts;
//   double    TempRateMeasurement;   // Counts/Min (-32768..32767)


   if(strcmp(xtractid,"SVD") == 0)
      XSVD(Msg);                   // call extration and write routine    

   if(fxtract)
      return;
   else if((Msg->ChannelData[0].ChannelStatus1 & MAGNA_ON) != 0) { 
      // message 1191 will be displayed instead of the message 1102 fields
      if(Flag1102 == TRUE) {
      	Flag1102 = FALSE;
      	show_screen_titles(); 
      }
   }  
   else {
      Flag1102 = TRUE;
      show_screen_titles();
      ShowRNG(Msg);        
   }
   
   // get new clock bias and clock drift values
   GpsTimePhase = utrip2dbl(&Msg->TimeMarkData.GpsTimePhase.ThreeShorts)
                            * GF_SPEED_OF_LIGHT / (X50TWOP45); 
   GpsTimeVelocity = (Msg->TimeMarkData.GpsTimeVelocity)
                      * GF_SPEED_OF_LIGHT / TWOP45;

   // get temp measurement and rate
//   if(!MSG1110){
     TRef = 23.0f;
     S0   = -0.007801056f;
     T0   = 47000;//43890;
//   }
//   else{
//     MSG1110 = 0;
//   }    
   Counts = Msg->TimeMarkData.TempMeasurement;
   TempMeasurement = TRef + ((float)Counts - (float)T0) * S0;
//   TempRateMeasurement = (Msg->TimeMarkData.TempRateMeasurement) * (-7.801056e-3);
   
   sprintf(Buf,"%9ld",(long)GpsTimePhase            );ShowText(Buf,CBDR  ,CBDC+2); 
   sprintf(Buf,"%9ld",(long)GpsTimeVelocity         );ShowText(Buf,CBDR+1,CBDC+2); 
   sprintf(Buf,"%4.1f",(float)TempMeasurement             );ShowText(Buf,CBDR+2,CBDC+7);
//   sprintf(Buf,"%4.1lf",TempRateMeasurement         );ShowText(Buf,CBDR+3,CBDC+8);
   sprintf(Buf,"%5hu",Counts                        );ShowText(Buf,CBDR+3,CBDC+6); 
 
} 


void ShowRNG(tMSG1102 *Msg)
{
   char    Buf[80] = ""; 
   tSHORT  i;   
   
   
   extern FILE   *stream3;
 
   short   CN0          [GI_NUM_HW_CHAN];
   double  CodePhase    [GI_NUM_HW_CHAN];
   double  CarrierPhase [GI_NUM_HW_CHAN];
   double  CarrierRate  [GI_NUM_HW_CHAN];
   double  GPSMeasurementTime;
   

   // perform special processing for output anc convert values  
   GPSMeasurementTime  = (double) Msg->TimeMarkData.GpsMsrmntTimeIntPrtn * 0.02;
   GPSMeasurementTime += ((double) Msg->TimeMarkData.GpsMsrmntTimeFrctnlPrtn * 10.0e-9);
   
   // check boundaries for gps measurement time
   if( GPSMeasurementTime < 0 )      GPSMeasurementTime += 604800;  // add 1 week  
   if( GPSMeasurementTime > 604800 ) GPSMeasurementTime -= 604800;  // sub 1 week  
   
   for(i=0; i<GI_NUM_HW_CHAN; i++){
      if(Msg->ChannelData[i].CN0 > 375){        
         CN0[i]  = (tUSHORT)(20.0 *
                    log10((tDOUBLE) (Msg->ChannelData[i].CN0)) - 29.5);
      }
      else{
         CN0[i]   = 0;  

         // set unused bit to make status non-zero for postprocessing
		 Msg->ChannelData[i].ChannelStatus1 = 0x0100; 
      }
     
      CodePhase[i]    = utrip2dbl(&Msg->ChannelData[i].CodePhase.ThreeShorts) 
                               * GF_SPEED_OF_LIGHT / (X50TWOP45); 
      CarrierPhase[i] = utrip2dbl(&Msg->ChannelData[i].CarrierPhase.ThreeShorts) 
                               * GF_SPEED_OF_LIGHT / (X50TWOP45);
      CarrierRate[i]  = (Msg->ChannelData[i].CarrierRate) 
                               * GF_SPEED_OF_LIGHT / TWOP45;
  }
   
   // write extracted data to a file

   if(xtract){
     if(strcmp(xtractid,"RNG") == 0){    
         for(i=0; i<GI_NUM_HW_CHAN; i++) {
           if ( (xtractchannel == 13 && Msg->ChannelData[i].PRN != 0) ||
           	    ((xtractchannel-1) == i) ) {
              fprintf(stream3, "%16.9lf %2d %2d %4d %12.3lf %12.3lf %9.3lf\r\n",                     
                    GPSMeasurementTime,i+1,Msg->ChannelData[i].PRN,
                    Msg->ChannelData[i].ChannelStatus1,
                    CarrierPhase[i], CodePhase[i], CarrierRate[i]);
           }
         }
      }
   } 
   
// output the data values   
   sprintf(Buf,"%05d",Msg->TimeMarkData.SequenceNumber);ShowText(Buf,TIMR+ 6,TIMC+ 4);

   for(i=0; i<GI_NUM_HW_CHAN; i++){ 
   sprintf(Buf,"%2d"  ,i + 1                     );ShowText(Buf,CHNR+ i,CHNC   ); 
   sprintf(Buf,"%2d"  ,Msg->ChannelData[i].PRN   );ShowText(Buf,CHNR+ i,CHNC+ 4);  
// sprintf(Buf,"%2d"  ,CN0[i]                    );ShowText(Buf,CHNR+ i,CHNC+14); 
  
   if(Msg->ChannelData[i].CarrierRate != 0){ 
   sprintf(Buf,"%12.3lf",CarrierPhase[i]         );ShowText(Buf,CPMR+ i,CPMC-1   ); 
   sprintf(Buf,"%12.3lf",CodePhase[i]            );ShowText(Buf,PRMR+ i,PRMC-2 ); 
   sprintf(Buf,"%9.3lf" ,CarrierRate[i]          );ShowText(Buf,PRMR+ i,PRMC+11); 
   sprintf(Buf,"%04X"  ,Msg->ChannelData[i].ChannelStatus1);
                                                   ShowText(Buf,CPBR+ i,CPBC-2);
   sprintf(Buf,"%04X"  ,Msg->ChannelData[i].ChannelStatus2);
                                                   ShowText(Buf,CPBR+ i,CPBC+3);
   }
   else{
   //           123456789012 
   sprintf(Buf,"            "		);ShowText(Buf,CPMR+ i,CPMC-1 ); 
   sprintf(Buf,"            "		);ShowText(Buf,PRMR+ i,PRMC-2 ); 
   sprintf(Buf,"         "			);ShowText(Buf,PRMR+ i,PRMC+11);  
   sprintf(Buf,"    "				);ShowText(Buf,CPBR+ i,CPBC-2 );
   sprintf(Buf,"    "				);ShowText(Buf,CPBR+ i,CPBC+3 );
   } 
   }
}
